//********************************************************************************
//Project Name : CGF0X2A Sensorless solution
//Date : 2024.9.19
//MCU : CGF0X2A

//********************************************************************************
//								     Include
//********************************************************************************
#include "Allhex.h"
#include "Math.h"
//********************************************************************************
//								      MEMO
//********************************************************************************
/*
- Sep.20, 2024 Reviced(V0.0)
- Oct.30, 2024 Reviced(V1.0)
- Nov.26, 2024 Reviced(V2.0)
- Jan.10, 2025 Reviced(V3.0)
- Fab.21, 2025 Reviced(V4.0)
- Apr.24, 2025 Reviced(V5.0)
*/	
//********************************************************************************
//								       RAM
//********************************************************************************
//datawqܶqbe128r`]0x00~0x7F^a}Ŷ
//idatawqܶqb]0x00~0xFF^a}Ŷ
//xdatawqܶqhObW~XiRAMŶ]@~0xF000~0xF1FFŶAŶjp]ӲAS~RAM^

//datawqܶqt׳̧֡AidataAxdatae̺C
//`QϥΪܼƥdata/idataŧi; `ϥΪܼƥxdataŧi.
//LSOŧiܼơAw]Odata

bit		Timer0Flag				= 0;
bit		PwmFlag 				= 0;	//PWM MAX INT.
uint8 	Timer0Count 			= 0;

#if(1)
void InitMotorParam(void){
	motorParam.opa_gain		= OPA_GAIN;
	motorParam.SPEED_TEMP		= EstimatedSpeed;
	motorParam.PWM_F    		= PWM_Frequency;
	motorParam.RATED_SPEED_MAX  	= RATED_SPEEDMAX;
	motorParam.RATED_VOLTAGE    	= VBUS;
	motorParam.KSLF_MIN		= SMO_KSLF_MIN;
	motorParam.KSLF_MAX		= SMO_KSLF_MAX;
	motorParam.KSLIDE_MIN		= SMO_KSLIDE_MIN;
	motorParam.KSLIDE_MAX		= SMO_KSLIDE_MAX;
	motorParam.RS_Ohm          	= (float)RS;
	motorParam.LS_H            	= (float)LS;
	motorParam.SHUNT_R		= (float)R_SHUNT;
}
#endif
//********************************************************************************
//								    MAIN
//********************************************************************************
void main(void){
	unsigned int Power_on_delay_counter = 0;
	for(Power_on_delay_counter=0;Power_on_delay_counter<dPOWER_ON_DELAY_Mechanical_Cycle;Power_on_delay_counter++){};
	
	PWM_Init();
	GPIO_Init();
	Adc_Init();
	Timer_Init();
	OCP_Init();
	MDE_Init();
	Interrupt_Init();
	//LVD_Init();
	WatchDog_Init();
	
	#if (I_CAPTURE_MODE==1)
		CAP_Init();
	#endif
	
	#if (E_CAPTURE_MODE==1)
		EXCAP_Init();
	#endif
	InitMotorParam();	
	FOCParaCal_Fun(&motorParam);
	
	#if (dUART_MODE == 1)
		Uart_Definition();
	#endif
	
	#if (EEPROM_MODE==1)
		EEP_Power_Init_read_data();
	#endif
	
//	#if (POWER_CONTROL == 1)
//		InitPI_ALL();
//		InitPI(&PIParm_Watt);
//	#endif
	
	while(1){
		WatchDog_Refresh();
		//PWM MAX INT.	
		if(PwmFlag == 1){
			#if (BEMF_TAILWIND_RES_FUNCTION == 1) || (BEMF_TAILWIND_DIODE_FUNCTION == 1)
				if(MotorState == M_TAILWIND){
					#if(BEMF_TAILWIND_RES_FUNCTION == 1)	
						TailWindDetect_TwoBEMF_Fun();
					#endif
	
					#if(BEMF_TAILWIND_DIODE_FUNCTION == 1)
						#if (BREAK_FUNCTION == 1)
							if(!ZeroPointCheck)
								Break_Fun();
							else
								PWM_SetActive();
							TailWindDetect_TwoBEMF_Fun();
						#else
							#error Wrong Setting BREAK_FUNCTION Disable !!
						#endif
					#endif
				}
			#endif

			PwmFlag = 0;
		}

		//UART		
		#if (dUART_MODE == 1)
			if(RxState == RX_FINISH){
				Uart_ReadPackage_Build();
			}
			if(UartFlag == 1){	//10ms				
				SFR_PAGE = 0; Debug_A = PI_OUT;//PI_FB;//Iq_FB//Vsp_avg
				SFR_PAGE = 2; Debug_B = PI_CMD;//Id_FB//Ibus_avg
				SFR_PAGE = 2; Debug_C = PI_FB;//speed//Watt
				SFR_PAGE = 2; Debug_D = PI_OUT;//PI_OUT;//Iq PI_out
				SFR_PAGE = 3; Debug_E = (EstimatedSpeed/(POLE_PAIRS));//MotorState;
				SFR_PAGE = 5; Debug_F = MotorErrorState;//MotorErrorState;
				Uart_Package_Build();
				UartFlag = 0;
			}
		#endif

		//1ms
		if(Timer0Flag == 1){
			Timer0Flag = 0;

			if((Timer0Count & 0x0F) == 0){// 0.16.32...etc 16ms

			}					
			else if((Timer0Count & 0x1F) == 2){//2.34...etc 2 *16ms
				//GET_IQ_MACRO(IqFb);
			}
			else if((Timer0Count & 0x1F) == 4){//4.36...etc 2 *16ms
				//GET_VQ_MACRO(IqPiOut);
			}
			else if((Timer0Count & 0x1F) == 6){//6.38...etc 2 *16ms
				GET_SPEED_MACRO(EstimatedSpeed);
				SMOPara_Cal_Fun(&motorParam);
			}
		}
	}
}

